/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFilterRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, DeleteFilterRequest> {
    private final String detectorId;
    private final String filterName;

    private DeleteFilterRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.filterName = builder.filterName;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String filterName() {
        return this.filterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFilterRequest)) {
            return false;
        }
        DeleteFilterRequest other = (DeleteFilterRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.filterName(), other.filterName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteFilterRequest").add("DetectorId", (Object)this.detectorId()).add("FilterName", (Object)this.filterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "FilterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String filterName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFilterRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.filterName(model.filterName);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getFilterName() {
            return this.filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFilterRequest build() {
            return new DeleteFilterRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, DeleteFilterRequest> {
        public Builder detectorId(String var1);

        public Builder filterName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

