/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.DomainDetails;
import software.amazon.awssdk.services.guardduty.model.RemoteIpDetails;
import software.amazon.awssdk.services.guardduty.transform.AwsApiCallActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsApiCallAction
implements StructuredPojo,
ToCopyableBuilder<Builder, AwsApiCallAction> {
    private final String api;
    private final String callerType;
    private final DomainDetails domainDetails;
    private final RemoteIpDetails remoteIpDetails;
    private final String serviceName;

    private AwsApiCallAction(BuilderImpl builder) {
        this.api = builder.api;
        this.callerType = builder.callerType;
        this.domainDetails = builder.domainDetails;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.serviceName = builder.serviceName;
    }

    public String api() {
        return this.api;
    }

    public String callerType() {
        return this.callerType;
    }

    public DomainDetails domainDetails() {
        return this.domainDetails;
    }

    public RemoteIpDetails remoteIpDetails() {
        return this.remoteIpDetails;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.api());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiCallAction)) {
            return false;
        }
        AwsApiCallAction other = (AwsApiCallAction)obj;
        return Objects.equals(this.api(), other.api()) && Objects.equals(this.callerType(), other.callerType()) && Objects.equals(this.domainDetails(), other.domainDetails()) && Objects.equals(this.remoteIpDetails(), other.remoteIpDetails()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public String toString() {
        return ToString.builder((String)"AwsApiCallAction").add("Api", (Object)this.api()).add("CallerType", (Object)this.callerType()).add("DomainDetails", (Object)this.domainDetails()).add("RemoteIpDetails", (Object)this.remoteIpDetails()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Api": {
                return Optional.ofNullable(clazz.cast(this.api()));
            }
            case "CallerType": {
                return Optional.ofNullable(clazz.cast(this.callerType()));
            }
            case "DomainDetails": {
                return Optional.ofNullable(clazz.cast(this.domainDetails()));
            }
            case "RemoteIpDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteIpDetails()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AwsApiCallActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String api;
        private String callerType;
        private DomainDetails domainDetails;
        private RemoteIpDetails remoteIpDetails;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiCallAction model) {
            this.api(model.api);
            this.callerType(model.callerType);
            this.domainDetails(model.domainDetails);
            this.remoteIpDetails(model.remoteIpDetails);
            this.serviceName(model.serviceName);
        }

        public final String getApi() {
            return this.api;
        }

        @Override
        public final Builder api(String api) {
            this.api = api;
            return this;
        }

        public final void setApi(String api) {
            this.api = api;
        }

        public final String getCallerType() {
            return this.callerType;
        }

        @Override
        public final Builder callerType(String callerType) {
            this.callerType = callerType;
            return this;
        }

        public final void setCallerType(String callerType) {
            this.callerType = callerType;
        }

        public final DomainDetails.Builder getDomainDetails() {
            return this.domainDetails != null ? this.domainDetails.toBuilder() : null;
        }

        @Override
        public final Builder domainDetails(DomainDetails domainDetails) {
            this.domainDetails = domainDetails;
            return this;
        }

        public final void setDomainDetails(DomainDetails.BuilderImpl domainDetails) {
            this.domainDetails = domainDetails != null ? domainDetails.build() : null;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return this.remoteIpDetails != null ? this.remoteIpDetails.toBuilder() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public AwsApiCallAction build() {
            return new AwsApiCallAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AwsApiCallAction> {
        public Builder api(String var1);

        public Builder callerType(String var1);

        public Builder domainDetails(DomainDetails var1);

        default public Builder domainDetails(Consumer<DomainDetails.Builder> domainDetails) {
            return this.domainDetails((DomainDetails)((DomainDetails.Builder)DomainDetails.builder().applyMutation(domainDetails)).build());
        }

        public Builder remoteIpDetails(RemoteIpDetails var1);

        default public Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return this.remoteIpDetails((RemoteIpDetails)((RemoteIpDetails.Builder)RemoteIpDetails.builder().applyMutation(remoteIpDetails)).build());
        }

        public Builder serviceName(String var1);
    }
}

