/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.AccessKeyDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessKeyDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, AccessKeyDetails> {
    private final String accessKeyId;
    private final String principalId;
    private final String userName;
    private final String userType;

    private AccessKeyDetails(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.principalId = builder.principalId;
        this.userName = builder.userName;
        this.userType = builder.userType;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String principalId() {
        return this.principalId;
    }

    public String userName() {
        return this.userName;
    }

    public String userType() {
        return this.userType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKeyDetails)) {
            return false;
        }
        AccessKeyDetails other = (AccessKeyDetails)obj;
        return Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.userType(), other.userType());
    }

    public String toString() {
        return ToString.builder((String)"AccessKeyDetails").add("AccessKeyId", (Object)this.accessKeyId()).add("PrincipalId", (Object)this.principalId()).add("UserName", (Object)this.userName()).add("UserType", (Object)this.userType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "UserType": {
                return Optional.ofNullable(clazz.cast(this.userType()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccessKeyDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessKeyId;
        private String principalId;
        private String userName;
        private String userType;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessKeyDetails model) {
            this.accessKeyId(model.accessKeyId);
            this.principalId(model.principalId);
            this.userName(model.userName);
            this.userType(model.userType);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getUserType() {
            return this.userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        public AccessKeyDetails build() {
            return new AccessKeyDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccessKeyDetails> {
        public Builder accessKeyId(String var1);

        public Builder principalId(String var1);

        public Builder userName(String var1);

        public Builder userType(String var1);
    }
}

