/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptInvitationRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, AcceptInvitationRequest> {
    private final String detectorId;
    private final String invitationId;
    private final String masterId;

    private AcceptInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.invitationId = builder.invitationId;
        this.masterId = builder.masterId;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String invitationId() {
        return this.invitationId;
    }

    public String masterId() {
        return this.masterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptInvitationRequest)) {
            return false;
        }
        AcceptInvitationRequest other = (AcceptInvitationRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.invitationId(), other.invitationId()) && Objects.equals(this.masterId(), other.masterId());
    }

    public String toString() {
        return ToString.builder((String)"AcceptInvitationRequest").add("DetectorId", (Object)this.detectorId()).add("InvitationId", (Object)this.invitationId()).add("MasterId", (Object)this.masterId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "InvitationId": {
                return Optional.ofNullable(clazz.cast(this.invitationId()));
            }
            case "MasterId": {
                return Optional.ofNullable(clazz.cast(this.masterId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String invitationId;
        private String masterId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptInvitationRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.invitationId(model.invitationId);
            this.masterId(model.masterId);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getInvitationId() {
            return this.invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        public final String getMasterId() {
            return this.masterId;
        }

        @Override
        public final Builder masterId(String masterId) {
            this.masterId = masterId;
            return this;
        }

        public final void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptInvitationRequest build() {
            return new AcceptInvitationRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, AcceptInvitationRequest> {
        public Builder detectorId(String var1);

        public Builder invitationId(String var1);

        public Builder masterId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

