/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.BadRequestException;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.CreateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.CreateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.CreateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.CreateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.GetDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.GetDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.GetFilterRequest;
import software.amazon.awssdk.services.guardduty.model.GetFilterResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.guardduty.model.GetIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetMembersRequest;
import software.amazon.awssdk.services.guardduty.model.GetMembersResponse;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.GuardDutyException;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.InternalServerErrorException;
import software.amazon.awssdk.services.guardduty.model.InviteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.InviteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.ListFiltersRequest;
import software.amazon.awssdk.services.guardduty.model.ListFiltersResponse;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ListFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse;
import software.amazon.awssdk.services.guardduty.model.ListMembersRequest;
import software.amazon.awssdk.services.guardduty.model.ListMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable;
import software.amazon.awssdk.services.guardduty.transform.AcceptInvitationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.AcceptInvitationResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ArchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ArchiveFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateDetectorResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateFilterResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateIpSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateSampleFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateSampleFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateThreatIntelSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeclineInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeclineInvitationsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteDetectorResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteFilterResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteInvitationsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteIpSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteThreatIntelSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateFromMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateFromMasterAccountResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetDetectorResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFilterResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsStatisticsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsStatisticsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetInvitationsCountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetInvitationsCountResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetIpSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMasterAccountResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetThreatIntelSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.InviteMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.InviteMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListDetectorsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListDetectorsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFiltersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFiltersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListInvitationsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListIpSetsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListIpSetsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListThreatIntelSetsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListThreatIntelSetsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.StartMonitoringMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.StartMonitoringMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.StopMonitoringMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.StopMonitoringMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UnarchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UnarchiveFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateDetectorResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFilterResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFindingsFeedbackRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFindingsFeedbackResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateIpSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateThreatIntelSetResponseUnmarshaller;

@SdkInternalApi
final class DefaultGuardDutyClient
implements GuardDutyClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGuardDutyClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "guardduty";
    }

    @Override
    public AcceptInvitationResponse acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcceptInvitationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (AcceptInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptInvitationRequest).withMarshaller((Marshaller)new AcceptInvitationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ArchiveFindingsResponse archiveFindings(ArchiveFindingsRequest archiveFindingsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ArchiveFindingsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ArchiveFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)archiveFindingsRequest).withMarshaller((Marshaller)new ArchiveFindingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDetectorResponse createDetector(CreateDetectorRequest createDetectorRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDetectorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDetectorRequest).withMarshaller((Marshaller)new CreateDetectorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateFilterResponse createFilter(CreateFilterRequest createFilterRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFilterResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFilterRequest).withMarshaller((Marshaller)new CreateFilterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateIpSetResponse createIPSet(CreateIpSetRequest createIpSetRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateIpSetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateIpSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIpSetRequest).withMarshaller((Marshaller)new CreateIpSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateMembersResponse createMembers(CreateMembersRequest createMembersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMembersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMembersRequest).withMarshaller((Marshaller)new CreateMembersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateSampleFindingsResponse createSampleFindings(CreateSampleFindingsRequest createSampleFindingsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSampleFindingsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateSampleFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSampleFindingsRequest).withMarshaller((Marshaller)new CreateSampleFindingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateThreatIntelSetResponse createThreatIntelSet(CreateThreatIntelSetRequest createThreatIntelSetRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateThreatIntelSetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateThreatIntelSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createThreatIntelSetRequest).withMarshaller((Marshaller)new CreateThreatIntelSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeclineInvitationsResponse declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeclineInvitationsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeclineInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)declineInvitationsRequest).withMarshaller((Marshaller)new DeclineInvitationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDetectorResponse deleteDetector(DeleteDetectorRequest deleteDetectorRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDetectorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDetectorRequest).withMarshaller((Marshaller)new DeleteDetectorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteFilterResponse deleteFilter(DeleteFilterRequest deleteFilterRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFilterResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFilterRequest).withMarshaller((Marshaller)new DeleteFilterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteIpSetResponse deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteIpSetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteIpSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIpSetRequest).withMarshaller((Marshaller)new DeleteIpSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteInvitationsResponse deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInvitationsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInvitationsRequest).withMarshaller((Marshaller)new DeleteInvitationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteMembersResponse deleteMembers(DeleteMembersRequest deleteMembersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMembersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMembersRequest).withMarshaller((Marshaller)new DeleteMembersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteThreatIntelSetResponse deleteThreatIntelSet(DeleteThreatIntelSetRequest deleteThreatIntelSetRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteThreatIntelSetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteThreatIntelSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteThreatIntelSetRequest).withMarshaller((Marshaller)new DeleteThreatIntelSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisassociateFromMasterAccountResponse disassociateFromMasterAccount(DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateFromMasterAccountResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DisassociateFromMasterAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateFromMasterAccountRequest).withMarshaller((Marshaller)new DisassociateFromMasterAccountRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisassociateMembersResponse disassociateMembers(DisassociateMembersRequest disassociateMembersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateMembersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DisassociateMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateMembersRequest).withMarshaller((Marshaller)new DisassociateMembersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetDetectorResponse getDetector(GetDetectorRequest getDetectorRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDetectorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDetectorRequest).withMarshaller((Marshaller)new GetDetectorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFilterResponse getFilter(GetFilterRequest getFilterRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFilterResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFilterRequest).withMarshaller((Marshaller)new GetFilterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFindingsResponse getFindings(GetFindingsRequest getFindingsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFindingsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingsRequest).withMarshaller((Marshaller)new GetFindingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFindingsStatisticsResponse getFindingsStatistics(GetFindingsStatisticsRequest getFindingsStatisticsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFindingsStatisticsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetFindingsStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingsStatisticsRequest).withMarshaller((Marshaller)new GetFindingsStatisticsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetIpSetResponse getIPSet(GetIpSetRequest getIpSetRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetIpSetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetIpSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIpSetRequest).withMarshaller((Marshaller)new GetIpSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetInvitationsCountResponse getInvitationsCount(GetInvitationsCountRequest getInvitationsCountRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInvitationsCountResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetInvitationsCountResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInvitationsCountRequest).withMarshaller((Marshaller)new GetInvitationsCountRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetMasterAccountResponse getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMasterAccountResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetMasterAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMasterAccountRequest).withMarshaller((Marshaller)new GetMasterAccountRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetMembersResponse getMembers(GetMembersRequest getMembersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMembersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMembersRequest).withMarshaller((Marshaller)new GetMembersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetThreatIntelSetResponse getThreatIntelSet(GetThreatIntelSetRequest getThreatIntelSetRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetThreatIntelSetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetThreatIntelSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getThreatIntelSetRequest).withMarshaller((Marshaller)new GetThreatIntelSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public InviteMembersResponse inviteMembers(InviteMembersRequest inviteMembersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InviteMembersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (InviteMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)inviteMembersRequest).withMarshaller((Marshaller)new InviteMembersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDetectorsResponse listDetectors(ListDetectorsRequest listDetectorsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDetectorsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListDetectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDetectorsRequest).withMarshaller((Marshaller)new ListDetectorsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDetectorsIterable listDetectorsPaginator(ListDetectorsRequest listDetectorsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListDetectorsIterable(this, this.applyPaginatorUserAgent(listDetectorsRequest));
    }

    @Override
    public ListFiltersResponse listFilters(ListFiltersRequest listFiltersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFiltersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFiltersRequest).withMarshaller((Marshaller)new ListFiltersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListFiltersIterable listFiltersPaginator(ListFiltersRequest listFiltersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListFiltersIterable(this, this.applyPaginatorUserAgent(listFiltersRequest));
    }

    @Override
    public ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFindingsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFindingsRequest).withMarshaller((Marshaller)new ListFindingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListFindingsIterable listFindingsPaginator(ListFindingsRequest listFindingsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListFindingsIterable(this, this.applyPaginatorUserAgent(listFindingsRequest));
    }

    @Override
    public ListIpSetsResponse listIPSets(ListIpSetsRequest listIpSetsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListIpSetsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListIpSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIpSetsRequest).withMarshaller((Marshaller)new ListIpSetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListIPSetsIterable listIPSetsPaginator(ListIpSetsRequest listIpSetsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListIPSetsIterable(this, this.applyPaginatorUserAgent(listIpSetsRequest));
    }

    @Override
    public ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInvitationsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInvitationsRequest).withMarshaller((Marshaller)new ListInvitationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListInvitationsIterable listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListInvitationsIterable(this, this.applyPaginatorUserAgent(listInvitationsRequest));
    }

    @Override
    public ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMembersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMembersRequest).withMarshaller((Marshaller)new ListMembersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListMembersIterable(this, this.applyPaginatorUserAgent(listMembersRequest));
    }

    @Override
    public ListThreatIntelSetsResponse listThreatIntelSets(ListThreatIntelSetsRequest listThreatIntelSetsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListThreatIntelSetsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListThreatIntelSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listThreatIntelSetsRequest).withMarshaller((Marshaller)new ListThreatIntelSetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListThreatIntelSetsIterable listThreatIntelSetsPaginator(ListThreatIntelSetsRequest listThreatIntelSetsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListThreatIntelSetsIterable(this, this.applyPaginatorUserAgent(listThreatIntelSetsRequest));
    }

    @Override
    public StartMonitoringMembersResponse startMonitoringMembers(StartMonitoringMembersRequest startMonitoringMembersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartMonitoringMembersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartMonitoringMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMonitoringMembersRequest).withMarshaller((Marshaller)new StartMonitoringMembersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StopMonitoringMembersResponse stopMonitoringMembers(StopMonitoringMembersRequest stopMonitoringMembersRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopMonitoringMembersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StopMonitoringMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopMonitoringMembersRequest).withMarshaller((Marshaller)new StopMonitoringMembersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UnarchiveFindingsResponse unarchiveFindings(UnarchiveFindingsRequest unarchiveFindingsRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UnarchiveFindingsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UnarchiveFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unarchiveFindingsRequest).withMarshaller((Marshaller)new UnarchiveFindingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateDetectorResponse updateDetector(UpdateDetectorRequest updateDetectorRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDetectorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDetectorRequest).withMarshaller((Marshaller)new UpdateDetectorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateFilterResponse updateFilter(UpdateFilterRequest updateFilterRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFilterResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFilterRequest).withMarshaller((Marshaller)new UpdateFilterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateFindingsFeedbackResponse updateFindingsFeedback(UpdateFindingsFeedbackRequest updateFindingsFeedbackRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFindingsFeedbackResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateFindingsFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFindingsFeedbackRequest).withMarshaller((Marshaller)new UpdateFindingsFeedbackRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateIpSetResponse updateIPSet(UpdateIpSetRequest updateIpSetRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateIpSetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateIpSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIpSetRequest).withMarshaller((Marshaller)new UpdateIpSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateThreatIntelSetResponse updateThreatIntelSet(UpdateThreatIntelSetRequest updateThreatIntelSetRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateThreatIntelSetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateThreatIntelSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateThreatIntelSetRequest).withMarshaller((Marshaller)new UpdateThreatIntelSetRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(GuardDutyException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends GuardDutyRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GuardDutyRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

