/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UnarchiveFindingsRequestModelMarshaller {
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("detectorId").isBinary(false).build();
    private static final MarshallingInfo<List> FINDINGIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("findingIds").isBinary(false).build();
    private static final UnarchiveFindingsRequestModelMarshaller INSTANCE = new UnarchiveFindingsRequestModelMarshaller();

    private UnarchiveFindingsRequestModelMarshaller() {
    }

    public static UnarchiveFindingsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UnarchiveFindingsRequest unarchiveFindingsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)unarchiveFindingsRequest), (String)"unarchiveFindingsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)unarchiveFindingsRequest.detectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall(unarchiveFindingsRequest.findingIds(), FINDINGIDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

