/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.Service;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("action").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ARCHIVED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("archived").isBinary(false).build();
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").isBinary(false).build();
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detectorId").isBinary(false).build();
    private static final MarshallingInfo<String> EVENTFIRSTSEEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventFirstSeen").isBinary(false).build();
    private static final MarshallingInfo<String> EVENTLASTSEEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventLastSeen").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceRole").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceName").isBinary(false).build();
    private static final MarshallingInfo<String> USERFEEDBACK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userFeedback").isBinary(false).build();
    private static final ServiceMarshaller INSTANCE = new ServiceMarshaller();

    private ServiceMarshaller() {
    }

    public static ServiceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Service service, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)service, (String)"service");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)service.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)service.archived(), ARCHIVED_BINDING);
            protocolMarshaller.marshall((Object)service.count(), COUNT_BINDING);
            protocolMarshaller.marshall((Object)service.detectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall((Object)service.eventFirstSeen(), EVENTFIRSTSEEN_BINDING);
            protocolMarshaller.marshall((Object)service.eventLastSeen(), EVENTLASTSEEN_BINDING);
            protocolMarshaller.marshall((Object)service.resourceRole(), RESOURCEROLE_BINDING);
            protocolMarshaller.marshall((Object)service.serviceName(), SERVICENAME_BINDING);
            protocolMarshaller.marshall((Object)service.userFeedback(), USERFEEDBACK_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

