/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.ProductCode;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProductCodeMarshaller {
    private static final MarshallingInfo<String> CODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("code").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("productType").isBinary(false).build();
    private static final ProductCodeMarshaller INSTANCE = new ProductCodeMarshaller();

    private ProductCodeMarshaller() {
    }

    public static ProductCodeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProductCode productCode, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)productCode, (String)"productCode");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)productCode.code(), CODE_BINDING);
            protocolMarshaller.marshall((Object)productCode.productType(), PRODUCTTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

