/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.InstanceDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceDetailsMarshaller {
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> IAMINSTANCEPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamInstanceProfile").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceState").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceType").isBinary(false).build();
    private static final MarshallingInfo<String> LAUNCHTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("launchTime").isBinary(false).build();
    private static final MarshallingInfo<List> NETWORKINTERFACES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkInterfaces").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").isBinary(false).build();
    private static final MarshallingInfo<List> PRODUCTCODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("productCodes").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final InstanceDetailsMarshaller INSTANCE = new InstanceDetailsMarshaller();

    private InstanceDetailsMarshaller() {
    }

    public static InstanceDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceDetails instanceDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceDetails, (String)"instanceDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceDetails.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.iamInstanceProfile(), IAMINSTANCEPROFILE_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.imageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.instanceState(), INSTANCESTATE_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.launchTime(), LAUNCHTIME_BINDING);
            protocolMarshaller.marshall(instanceDetails.networkInterfaces(), NETWORKINTERFACES_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall(instanceDetails.productCodes(), PRODUCTCODES_BINDING);
            protocolMarshaller.marshall(instanceDetails.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

