/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.Finding;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FindingMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<Double> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("confidence").isBinary(false).build();
    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> PARTITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partition").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resource").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("schemaVersion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SERVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("service").isBinary(false).build();
    private static final MarshallingInfo<Double> SEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severity").isBinary(false).build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("title").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").isBinary(false).build();
    private static final FindingMarshaller INSTANCE = new FindingMarshaller();

    private FindingMarshaller() {
    }

    public static FindingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Finding finding, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)finding, (String)"finding");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)finding.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)finding.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)finding.confidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall((Object)finding.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)finding.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)finding.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)finding.partition(), PARTITION_BINDING);
            protocolMarshaller.marshall((Object)finding.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)finding.resource(), RESOURCE_BINDING);
            protocolMarshaller.marshall((Object)finding.schemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)finding.service(), SERVICE_BINDING);
            protocolMarshaller.marshall((Object)finding.severity(), SEVERITY_BINDING);
            protocolMarshaller.marshall((Object)finding.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)finding.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)finding.updatedAt(), UPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

