/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.Country;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CountryMarshaller {
    private static final MarshallingInfo<String> COUNTRYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("countryCode").isBinary(false).build();
    private static final MarshallingInfo<String> COUNTRYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("countryName").isBinary(false).build();
    private static final CountryMarshaller INSTANCE = new CountryMarshaller();

    private CountryMarshaller() {
    }

    public static CountryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Country country, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)country, (String)"country");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)country.countryCode(), COUNTRYCODE_BINDING);
            protocolMarshaller.marshall((Object)country.countryName(), COUNTRYNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

