/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.Condition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConditionMarshaller {
    private static final MarshallingInfo<List> EQ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eq").isBinary(false).build();
    private static final MarshallingInfo<Integer> GT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gt").isBinary(false).build();
    private static final MarshallingInfo<Integer> GTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gte").isBinary(false).build();
    private static final MarshallingInfo<Integer> LT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lt").isBinary(false).build();
    private static final MarshallingInfo<Integer> LTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lte").isBinary(false).build();
    private static final MarshallingInfo<List> NEQ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("neq").isBinary(false).build();
    private static final ConditionMarshaller INSTANCE = new ConditionMarshaller();

    private ConditionMarshaller() {
    }

    public static ConditionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Condition condition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)condition, (String)"condition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(condition.eq(), EQ_BINDING);
            protocolMarshaller.marshall((Object)condition.gt(), GT_BINDING);
            protocolMarshaller.marshall((Object)condition.gte(), GTE_BINDING);
            protocolMarshaller.marshall((Object)condition.lt(), LT_BINDING);
            protocolMarshaller.marshall((Object)condition.lte(), LTE_BINDING);
            protocolMarshaller.marshall(condition.neq(), NEQ_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

