/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.City;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CityMarshaller {
    private static final MarshallingInfo<String> CITYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cityName").isBinary(false).build();
    private static final CityMarshaller INSTANCE = new CityMarshaller();

    private CityMarshaller() {
    }

    public static CityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(City city, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)city, (String)"city");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)city.cityName(), CITYNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

