/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ListFindingsResponse;

public class ListFindingsPublisher
implements SdkPublisher<ListFindingsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingsPublisher(GuardDutyAsyncClient client, ListFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingsPublisher(GuardDutyAsyncClient client, ListFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> findingIds() {
        Function<ListFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findingIds() != null) {
                return response.findingIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListFindingsPublisher resume(ListFindingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFindingsPublisher(this.client, (ListFindingsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListFindingsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListFindingsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListFindingsResponseFetcher
    implements AsyncPageFetcher<ListFindingsResponse> {
        private ListFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListFindingsResponse> nextPage(ListFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsPublisher.this.client.listFindings(ListFindingsPublisher.this.firstRequest);
            }
            return ListFindingsPublisher.this.client.listFindings((ListFindingsRequest)((Object)ListFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

