/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.City;
import software.amazon.awssdk.services.guardduty.model.Country;
import software.amazon.awssdk.services.guardduty.model.GeoLocation;
import software.amazon.awssdk.services.guardduty.model.Organization;
import software.amazon.awssdk.services.guardduty.transform.RemoteIpDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoteIpDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, RemoteIpDetails> {
    private final City city;
    private final Country country;
    private final GeoLocation geoLocation;
    private final String ipAddressV4;
    private final Organization organization;

    private RemoteIpDetails(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.geoLocation = builder.geoLocation;
        this.ipAddressV4 = builder.ipAddressV4;
        this.organization = builder.organization;
    }

    public City city() {
        return this.city;
    }

    public Country country() {
        return this.country;
    }

    public GeoLocation geoLocation() {
        return this.geoLocation;
    }

    public String ipAddressV4() {
        return this.ipAddressV4;
    }

    public Organization organization() {
        return this.organization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressV4());
        hashCode = 31 * hashCode + Objects.hashCode(this.organization());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteIpDetails)) {
            return false;
        }
        RemoteIpDetails other = (RemoteIpDetails)obj;
        return Objects.equals(this.city(), other.city()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.geoLocation(), other.geoLocation()) && Objects.equals(this.ipAddressV4(), other.ipAddressV4()) && Objects.equals(this.organization(), other.organization());
    }

    public String toString() {
        return ToString.builder((String)"RemoteIpDetails").add("City", (Object)this.city()).add("Country", (Object)this.country()).add("GeoLocation", (Object)this.geoLocation()).add("IpAddressV4", (Object)this.ipAddressV4()).add("Organization", (Object)this.organization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "GeoLocation": {
                return Optional.ofNullable(clazz.cast(this.geoLocation()));
            }
            case "IpAddressV4": {
                return Optional.ofNullable(clazz.cast(this.ipAddressV4()));
            }
            case "Organization": {
                return Optional.ofNullable(clazz.cast(this.organization()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemoteIpDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private City city;
        private Country country;
        private GeoLocation geoLocation;
        private String ipAddressV4;
        private Organization organization;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteIpDetails model) {
            this.city(model.city);
            this.country(model.country);
            this.geoLocation(model.geoLocation);
            this.ipAddressV4(model.ipAddressV4);
            this.organization(model.organization);
        }

        public final City.Builder getCity() {
            return this.city != null ? this.city.toBuilder() : null;
        }

        @Override
        public final Builder city(City city) {
            this.city = city;
            return this;
        }

        public final void setCity(City.BuilderImpl city) {
            this.city = city != null ? city.build() : null;
        }

        public final Country.Builder getCountry() {
            return this.country != null ? this.country.toBuilder() : null;
        }

        @Override
        public final Builder country(Country country) {
            this.country = country;
            return this;
        }

        public final void setCountry(Country.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        public final GeoLocation.Builder getGeoLocation() {
            return this.geoLocation != null ? this.geoLocation.toBuilder() : null;
        }

        @Override
        public final Builder geoLocation(GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public final void setGeoLocation(GeoLocation.BuilderImpl geoLocation) {
            this.geoLocation = geoLocation != null ? geoLocation.build() : null;
        }

        public final String getIpAddressV4() {
            return this.ipAddressV4;
        }

        @Override
        public final Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            return this;
        }

        public final void setIpAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
        }

        public final Organization.Builder getOrganization() {
            return this.organization != null ? this.organization.toBuilder() : null;
        }

        @Override
        public final Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public final void setOrganization(Organization.BuilderImpl organization) {
            this.organization = organization != null ? organization.build() : null;
        }

        public RemoteIpDetails build() {
            return new RemoteIpDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemoteIpDetails> {
        public Builder city(City var1);

        default public Builder city(Consumer<City.Builder> city) {
            return this.city((City)((City.Builder)City.builder().applyMutation(city)).build());
        }

        public Builder country(Country var1);

        default public Builder country(Consumer<Country.Builder> country) {
            return this.country((Country)((Country.Builder)Country.builder().applyMutation(country)).build());
        }

        public Builder geoLocation(GeoLocation var1);

        default public Builder geoLocation(Consumer<GeoLocation.Builder> geoLocation) {
            return this.geoLocation((GeoLocation)((GeoLocation.Builder)GeoLocation.builder().applyMutation(geoLocation)).build());
        }

        public Builder ipAddressV4(String var1);

        public Builder organization(Organization var1);

        default public Builder organization(Consumer<Organization.Builder> organization) {
            return this.organization((Organization)((Organization.Builder)Organization.builder().applyMutation(organization)).build());
        }
    }
}

