/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.ProductCodeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductCode
implements StructuredPojo,
ToCopyableBuilder<Builder, ProductCode> {
    private final String code;
    private final String productType;

    private ProductCode(BuilderImpl builder) {
        this.code = builder.code;
        this.productType = builder.productType;
    }

    public String code() {
        return this.code;
    }

    public String productType() {
        return this.productType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.productType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductCode)) {
            return false;
        }
        ProductCode other = (ProductCode)obj;
        return Objects.equals(this.code(), other.code()) && Objects.equals(this.productType(), other.productType());
    }

    public String toString() {
        return ToString.builder((String)"ProductCode").add("Code", (Object)this.code()).add("ProductType", (Object)this.productType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "ProductType": {
                return Optional.ofNullable(clazz.cast(this.productType()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProductCodeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String productType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductCode model) {
            this.code(model.code);
            this.productType(model.productType);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getProductType() {
            return this.productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public ProductCode build() {
            return new ProductCode(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProductCode> {
        public Builder code(String var1);

        public Builder productType(String var1);
    }
}

