/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.ThreatIntelSetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThreatIntelSetsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListThreatIntelSetsResponse> {
    private final String nextToken;
    private final List<String> threatIntelSetIds;

    private ListThreatIntelSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.threatIntelSetIds = builder.threatIntelSetIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> threatIntelSetIds() {
        return this.threatIntelSetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.threatIntelSetIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThreatIntelSetsResponse)) {
            return false;
        }
        ListThreatIntelSetsResponse other = (ListThreatIntelSetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.threatIntelSetIds(), other.threatIntelSetIds());
    }

    public String toString() {
        return ToString.builder((String)"ListThreatIntelSetsResponse").add("NextToken", (Object)this.nextToken()).add("ThreatIntelSetIds", this.threatIntelSetIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ThreatIntelSetIds": {
                return Optional.ofNullable(clazz.cast(this.threatIntelSetIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> threatIntelSetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListThreatIntelSetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.threatIntelSetIds(model.threatIntelSetIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getThreatIntelSetIds() {
            return this.threatIntelSetIds;
        }

        @Override
        public final Builder threatIntelSetIds(Collection<String> threatIntelSetIds) {
            this.threatIntelSetIds = ThreatIntelSetIdsCopier.copy(threatIntelSetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelSetIds(String ... threatIntelSetIds) {
            this.threatIntelSetIds(Arrays.asList(threatIntelSetIds));
            return this;
        }

        public final void setThreatIntelSetIds(Collection<String> threatIntelSetIds) {
            this.threatIntelSetIds = ThreatIntelSetIdsCopier.copy(threatIntelSetIds);
        }

        @Override
        public ListThreatIntelSetsResponse build() {
            return new ListThreatIntelSetsResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, ListThreatIntelSetsResponse> {
        public Builder nextToken(String var1);

        public Builder threatIntelSetIds(Collection<String> var1);

        public Builder threatIntelSetIds(String ... var1);
    }
}

