/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.Invitation;
import software.amazon.awssdk.services.guardduty.model.InvitationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvitationsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListInvitationsResponse> {
    private final List<Invitation> invitations;
    private final String nextToken;

    private ListInvitationsResponse(BuilderImpl builder) {
        super(builder);
        this.invitations = builder.invitations;
        this.nextToken = builder.nextToken;
    }

    public List<Invitation> invitations() {
        return this.invitations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invitations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvitationsResponse)) {
            return false;
        }
        ListInvitationsResponse other = (ListInvitationsResponse)((Object)obj);
        return Objects.equals(this.invitations(), other.invitations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListInvitationsResponse").add("Invitations", this.invitations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Invitations": {
                return Optional.ofNullable(clazz.cast(this.invitations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<Invitation> invitations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvitationsResponse model) {
            super(model);
            this.invitations(model.invitations);
            this.nextToken(model.nextToken);
        }

        public final Collection<Invitation.Builder> getInvitations() {
            return this.invitations != null ? (Collection)this.invitations.stream().map(Invitation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder invitations(Collection<Invitation> invitations) {
            this.invitations = InvitationsCopier.copy(invitations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(Invitation ... invitations) {
            this.invitations(Arrays.asList(invitations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(Consumer<Invitation.Builder> ... invitations) {
            this.invitations(Stream.of(invitations).map(c -> (Invitation)((Invitation.Builder)Invitation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInvitations(Collection<Invitation.BuilderImpl> invitations) {
            this.invitations = InvitationsCopier.copyFromBuilder(invitations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInvitationsResponse build() {
            return new ListInvitationsResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, ListInvitationsResponse> {
        public Builder invitations(Collection<Invitation> var1);

        public Builder invitations(Invitation ... var1);

        public Builder invitations(Consumer<Invitation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

