/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.Condition;
import software.amazon.awssdk.services.guardduty.model.MapOfConditionCopier;
import software.amazon.awssdk.services.guardduty.transform.FindingCriteriaMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingCriteria
implements StructuredPojo,
ToCopyableBuilder<Builder, FindingCriteria> {
    private final Map<String, Condition> criterion;

    private FindingCriteria(BuilderImpl builder) {
        this.criterion = builder.criterion;
    }

    public Map<String, Condition> criterion() {
        return this.criterion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.criterion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingCriteria)) {
            return false;
        }
        FindingCriteria other = (FindingCriteria)obj;
        return Objects.equals(this.criterion(), other.criterion());
    }

    public String toString() {
        return ToString.builder((String)"FindingCriteria").add("Criterion", this.criterion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Criterion": {
                return Optional.ofNullable(clazz.cast(this.criterion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FindingCriteriaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Condition> criterion = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingCriteria model) {
            this.criterion(model.criterion);
        }

        public final Map<String, Condition.Builder> getCriterion() {
            return this.criterion != null ? CollectionUtils.mapValues(this.criterion, Condition::toBuilder) : null;
        }

        @Override
        public final Builder criterion(Map<String, Condition> criterion) {
            this.criterion = MapOfConditionCopier.copy(criterion);
            return this;
        }

        public final void setCriterion(Map<String, Condition.BuilderImpl> criterion) {
            this.criterion = MapOfConditionCopier.copyFromBuilder(criterion);
        }

        public FindingCriteria build() {
            return new FindingCriteria(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FindingCriteria> {
        public Builder criterion(Map<String, Condition> var1);
    }
}

