/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.AccountDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, AccountDetail> {
    private final String accountId;
    private final String email;

    private AccountDetail(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.email = builder.email;
    }

    public String accountId() {
        return this.accountId;
    }

    public String email() {
        return this.email;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountDetail)) {
            return false;
        }
        AccountDetail other = (AccountDetail)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.email(), other.email());
    }

    public String toString() {
        return ToString.builder((String)"AccountDetail").add("AccountId", (Object)this.accountId()).add("Email", (Object)this.email()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String email;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountDetail model) {
            this.accountId(model.accountId);
            this.email(model.email);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public AccountDetail build() {
            return new AccountDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountDetail> {
        public Builder accountId(String var1);

        public Builder email(String var1);
    }
}

