/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.BadRequestException;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.CreateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.CreateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.GetDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.GetDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.guardduty.model.GetIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetMembersRequest;
import software.amazon.awssdk.services.guardduty.model.GetMembersResponse;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.GuardDutyException;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.InternalServerErrorException;
import software.amazon.awssdk.services.guardduty.model.InviteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.InviteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ListFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse;
import software.amazon.awssdk.services.guardduty.model.ListMembersRequest;
import software.amazon.awssdk.services.guardduty.model.ListMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.paginators.ListDetectorsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListFindingsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListIPSetsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListInvitationsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListMembersPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsPublisher;
import software.amazon.awssdk.services.guardduty.transform.AcceptInvitationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.AcceptInvitationResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ArchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ArchiveFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateDetectorResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateIpSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateSampleFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateSampleFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateThreatIntelSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeclineInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeclineInvitationsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteDetectorResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteInvitationsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteIpSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteThreatIntelSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateFromMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateFromMasterAccountResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetDetectorResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsStatisticsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsStatisticsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetInvitationsCountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetInvitationsCountResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetIpSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMasterAccountResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetThreatIntelSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.InviteMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.InviteMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListDetectorsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListDetectorsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListInvitationsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListIpSetsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListIpSetsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListThreatIntelSetsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListThreatIntelSetsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.StartMonitoringMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.StartMonitoringMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.StopMonitoringMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.StopMonitoringMembersResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UnarchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UnarchiveFindingsResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateDetectorResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFindingsFeedbackRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFindingsFeedbackResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateIpSetResponseUnmarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateThreatIntelSetResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultGuardDutyAsyncClient
implements GuardDutyAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultGuardDutyAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "guardduty";
    }

    @Override
    public CompletableFuture<AcceptInvitationResponse> acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcceptInvitationResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AcceptInvitationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptInvitationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ArchiveFindingsResponse> archiveFindings(ArchiveFindingsRequest archiveFindingsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ArchiveFindingsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ArchiveFindingsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)archiveFindingsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDetectorResponse> createDetector(CreateDetectorRequest createDetectorRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDetectorResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateDetectorRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDetectorRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateIpSetResponse> createIPSet(CreateIpSetRequest createIpSetRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateIpSetResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateIpSetRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIpSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMembersResponse> createMembers(CreateMembersRequest createMembersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMembersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateMembersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMembersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSampleFindingsResponse> createSampleFindings(CreateSampleFindingsRequest createSampleFindingsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSampleFindingsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateSampleFindingsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSampleFindingsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateThreatIntelSetResponse> createThreatIntelSet(CreateThreatIntelSetRequest createThreatIntelSetRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateThreatIntelSetResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateThreatIntelSetRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createThreatIntelSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeclineInvitationsResponse> declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeclineInvitationsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeclineInvitationsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)declineInvitationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDetectorResponse> deleteDetector(DeleteDetectorRequest deleteDetectorRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDetectorResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteDetectorRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDetectorRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteIpSetResponse> deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteIpSetResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteIpSetRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIpSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteInvitationsResponse> deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInvitationsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteInvitationsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInvitationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMembersResponse> deleteMembers(DeleteMembersRequest deleteMembersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMembersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteMembersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMembersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteThreatIntelSetResponse> deleteThreatIntelSet(DeleteThreatIntelSetRequest deleteThreatIntelSetRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteThreatIntelSetResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteThreatIntelSetRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteThreatIntelSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateFromMasterAccountResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DisassociateFromMasterAccountRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateFromMasterAccountRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateMembersResponse> disassociateMembers(DisassociateMembersRequest disassociateMembersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateMembersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DisassociateMembersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateMembersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDetectorResponse> getDetector(GetDetectorRequest getDetectorRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDetectorResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetDetectorRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDetectorRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFindingsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetFindingsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFindingsStatisticsResponse> getFindingsStatistics(GetFindingsStatisticsRequest getFindingsStatisticsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFindingsStatisticsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetFindingsStatisticsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingsStatisticsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetIpSetResponse> getIPSet(GetIpSetRequest getIpSetRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetIpSetResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetIpSetRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIpSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(GetInvitationsCountRequest getInvitationsCountRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInvitationsCountResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetInvitationsCountRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInvitationsCountRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMasterAccountResponse> getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMasterAccountResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetMasterAccountRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMasterAccountRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMembersResponse> getMembers(GetMembersRequest getMembersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMembersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetMembersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMembersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetThreatIntelSetResponse> getThreatIntelSet(GetThreatIntelSetRequest getThreatIntelSetRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetThreatIntelSetResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetThreatIntelSetRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getThreatIntelSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InviteMembersResponse> inviteMembers(InviteMembersRequest inviteMembersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InviteMembersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new InviteMembersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)inviteMembersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDetectorsResponse> listDetectors(ListDetectorsRequest listDetectorsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDetectorsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListDetectorsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDetectorsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListDetectorsPublisher listDetectorsPaginator(ListDetectorsRequest listDetectorsRequest) {
        return new ListDetectorsPublisher(this, this.applyPaginatorUserAgent(listDetectorsRequest));
    }

    @Override
    public CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFindingsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListFindingsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFindingsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListFindingsPublisher listFindingsPaginator(ListFindingsRequest listFindingsRequest) {
        return new ListFindingsPublisher(this, this.applyPaginatorUserAgent(listFindingsRequest));
    }

    @Override
    public CompletableFuture<ListIpSetsResponse> listIPSets(ListIpSetsRequest listIpSetsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListIpSetsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListIpSetsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIpSetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListIPSetsPublisher listIPSetsPaginator(ListIpSetsRequest listIpSetsRequest) {
        return new ListIPSetsPublisher(this, this.applyPaginatorUserAgent(listIpSetsRequest));
    }

    @Override
    public CompletableFuture<ListInvitationsResponse> listInvitations(ListInvitationsRequest listInvitationsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInvitationsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListInvitationsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInvitationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListInvitationsPublisher listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) {
        return new ListInvitationsPublisher(this, this.applyPaginatorUserAgent(listInvitationsRequest));
    }

    @Override
    public CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMembersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListMembersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMembersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListMembersPublisher listMembersPaginator(ListMembersRequest listMembersRequest) {
        return new ListMembersPublisher(this, this.applyPaginatorUserAgent(listMembersRequest));
    }

    @Override
    public CompletableFuture<ListThreatIntelSetsResponse> listThreatIntelSets(ListThreatIntelSetsRequest listThreatIntelSetsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListThreatIntelSetsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListThreatIntelSetsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listThreatIntelSetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListThreatIntelSetsPublisher listThreatIntelSetsPaginator(ListThreatIntelSetsRequest listThreatIntelSetsRequest) {
        return new ListThreatIntelSetsPublisher(this, this.applyPaginatorUserAgent(listThreatIntelSetsRequest));
    }

    @Override
    public CompletableFuture<StartMonitoringMembersResponse> startMonitoringMembers(StartMonitoringMembersRequest startMonitoringMembersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartMonitoringMembersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StartMonitoringMembersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMonitoringMembersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopMonitoringMembersResponse> stopMonitoringMembers(StopMonitoringMembersRequest stopMonitoringMembersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopMonitoringMembersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StopMonitoringMembersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopMonitoringMembersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UnarchiveFindingsResponse> unarchiveFindings(UnarchiveFindingsRequest unarchiveFindingsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UnarchiveFindingsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UnarchiveFindingsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unarchiveFindingsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDetectorResponse> updateDetector(UpdateDetectorRequest updateDetectorRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDetectorResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateDetectorRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDetectorRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFindingsFeedbackResponse> updateFindingsFeedback(UpdateFindingsFeedbackRequest updateFindingsFeedbackRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFindingsFeedbackResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateFindingsFeedbackRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFindingsFeedbackRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateIpSetResponse> updateIPSet(UpdateIpSetRequest updateIpSetRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateIpSetResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateIpSetRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIpSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateThreatIntelSetResponse> updateThreatIntelSet(UpdateThreatIntelSetRequest updateThreatIntelSetRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateThreatIntelSetResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateThreatIntelSetRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateThreatIntelSetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(GuardDutyException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    private <T extends GuardDutyRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-11").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GuardDutyRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

