/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.RemoteIpDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RemoteIpDetailsMarshaller {
    private static final MarshallingInfo<StructuredPojo> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("city").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("country").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> GEOLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("geoLocation").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESSV4_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddressV4").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ORGANIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("organization").isBinary(false).build();
    private static final RemoteIpDetailsMarshaller INSTANCE = new RemoteIpDetailsMarshaller();

    private RemoteIpDetailsMarshaller() {
    }

    public static RemoteIpDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RemoteIpDetails remoteIpDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)remoteIpDetails, (String)"remoteIpDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)remoteIpDetails.city(), CITY_BINDING);
            protocolMarshaller.marshall((Object)remoteIpDetails.country(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)remoteIpDetails.geoLocation(), GEOLOCATION_BINDING);
            protocolMarshaller.marshall((Object)remoteIpDetails.ipAddressV4(), IPADDRESSV4_BINDING);
            protocolMarshaller.marshall((Object)remoteIpDetails.organization(), ORGANIZATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

