/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.Member;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MemberMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").isBinary(false).build();
    private static final MarshallingInfo<String> DETECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detectorId").isBinary(false).build();
    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("email").isBinary(false).build();
    private static final MarshallingInfo<String> INVITEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("invitedAt").isBinary(false).build();
    private static final MarshallingInfo<String> MASTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("masterId").isBinary(false).build();
    private static final MarshallingInfo<String> RELATIONSHIPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relationshipStatus").isBinary(false).build();
    private static final MarshallingInfo<String> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").isBinary(false).build();
    private static final MemberMarshaller INSTANCE = new MemberMarshaller();

    private MemberMarshaller() {
    }

    public static MemberMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Member member, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)member, (String)"member");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)member.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)member.detectorId(), DETECTORID_BINDING);
            protocolMarshaller.marshall((Object)member.email(), EMAIL_BINDING);
            protocolMarshaller.marshall((Object)member.invitedAt(), INVITEDAT_BINDING);
            protocolMarshaller.marshall((Object)member.masterId(), MASTERID_BINDING);
            protocolMarshaller.marshall((Object)member.relationshipStatus(), RELATIONSHIPSTATUS_BINDING);
            protocolMarshaller.marshall((Object)member.updatedAt(), UPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

