/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.Master;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MasterMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").isBinary(false).build();
    private static final MarshallingInfo<String> INVITATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("invitationId").isBinary(false).build();
    private static final MarshallingInfo<String> INVITEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("invitedAt").isBinary(false).build();
    private static final MarshallingInfo<String> RELATIONSHIPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relationshipStatus").isBinary(false).build();
    private static final MasterMarshaller INSTANCE = new MasterMarshaller();

    private MasterMarshaller() {
    }

    public static MasterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Master master, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)master, (String)"master");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)master.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)master.invitationId(), INVITATIONID_BINDING);
            protocolMarshaller.marshall((Object)master.invitedAt(), INVITEDAT_BINDING);
            protocolMarshaller.marshall((Object)master.relationshipStatus(), RELATIONSHIPSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

