/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.LocalPortDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LocalPortDetailsMarshaller {
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("port").isBinary(false).build();
    private static final MarshallingInfo<String> PORTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("portName").isBinary(false).build();
    private static final LocalPortDetailsMarshaller INSTANCE = new LocalPortDetailsMarshaller();

    private LocalPortDetailsMarshaller() {
    }

    public static LocalPortDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LocalPortDetails localPortDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)localPortDetails, (String)"localPortDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)localPortDetails.port(), PORT_BINDING);
            protocolMarshaller.marshall((Object)localPortDetails.portName(), PORTNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

