/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.guardduty.model.FindingStatistics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FindingStatisticsMarshaller {
    private static final MarshallingInfo<Map> COUNTBYSEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("countBySeverity").isBinary(false).build();
    private static final FindingStatisticsMarshaller INSTANCE = new FindingStatisticsMarshaller();

    private FindingStatisticsMarshaller() {
    }

    public static FindingStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FindingStatistics findingStatistics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)findingStatistics, (String)"findingStatistics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(findingStatistics.countBySeverity(), COUNTBYSEVERITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

