/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.guardduty.model.Condition;

public class ConditionUnmarshaller
implements Unmarshaller<Condition, JsonUnmarshallerContext> {
    private static final ConditionUnmarshaller INSTANCE = new ConditionUnmarshaller();

    public Condition unmarshall(JsonUnmarshallerContext context) throws Exception {
        Condition.Builder conditionBuilder = Condition.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("eq", targetDepth)) {
                    context.nextToken();
                    conditionBuilder.eq(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("gt", targetDepth)) {
                    context.nextToken();
                    conditionBuilder.gt((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("gte", targetDepth)) {
                    context.nextToken();
                    conditionBuilder.gte((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("lt", targetDepth)) {
                    context.nextToken();
                    conditionBuilder.lt((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("lte", targetDepth)) {
                    context.nextToken();
                    conditionBuilder.lte((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("neq", targetDepth)) {
                    context.nextToken();
                    conditionBuilder.neq(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Condition)conditionBuilder.build();
    }

    public static ConditionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

