/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.AwsApiCallAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AwsApiCallActionMarshaller {
    private static final MarshallingInfo<String> API_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("api").isBinary(false).build();
    private static final MarshallingInfo<String> CALLERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("callerType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DOMAINDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REMOTEIPDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remoteIpDetails").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceName").isBinary(false).build();
    private static final AwsApiCallActionMarshaller INSTANCE = new AwsApiCallActionMarshaller();

    private AwsApiCallActionMarshaller() {
    }

    public static AwsApiCallActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AwsApiCallAction awsApiCallAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)awsApiCallAction, (String)"awsApiCallAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)awsApiCallAction.api(), API_BINDING);
            protocolMarshaller.marshall((Object)awsApiCallAction.callerType(), CALLERTYPE_BINDING);
            protocolMarshaller.marshall((Object)awsApiCallAction.domainDetails(), DOMAINDETAILS_BINDING);
            protocolMarshaller.marshall((Object)awsApiCallAction.remoteIpDetails(), REMOTEIPDETAILS_BINDING);
            protocolMarshaller.marshall((Object)awsApiCallAction.serviceName(), SERVICENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

