/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.Action;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActionMarshaller {
    private static final MarshallingInfo<String> ACTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AWSAPICALLACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsApiCallAction").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DNSREQUESTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dnsRequestAction").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NETWORKCONNECTIONACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkConnectionAction").isBinary(false).build();
    private static final ActionMarshaller INSTANCE = new ActionMarshaller();

    private ActionMarshaller() {
    }

    public static ActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Action action, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)action, (String)"action");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)action.actionType(), ACTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)action.awsApiCallAction(), AWSAPICALLACTION_BINDING);
            protocolMarshaller.marshall((Object)action.dnsRequestAction(), DNSREQUESTACTION_BINDING);
            protocolMarshaller.marshall((Object)action.networkConnectionAction(), NETWORKCONNECTIONACTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

