/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;

public class ListThreatIntelSetsIterable
implements SdkIterable<ListThreatIntelSetsResponse> {
    private final GuardDutyClient client;
    private final ListThreatIntelSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThreatIntelSetsIterable(GuardDutyClient client, ListThreatIntelSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThreatIntelSetsResponseFetcher();
    }

    public Iterator<ListThreatIntelSetsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<String> threatIntelSetIds() {
        Function<ListThreatIntelSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.threatIntelSetIds() != null) {
                return response.threatIntelSetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListThreatIntelSetsIterable resume(ListThreatIntelSetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListThreatIntelSetsIterable(this.client, (ListThreatIntelSetsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListThreatIntelSetsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListThreatIntelSetsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListThreatIntelSetsResponseFetcher
    implements SyncPageFetcher<ListThreatIntelSetsResponse> {
        private ListThreatIntelSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListThreatIntelSetsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListThreatIntelSetsResponse nextPage(ListThreatIntelSetsResponse previousPage) {
            if (previousPage == null) {
                return ListThreatIntelSetsIterable.this.client.listThreatIntelSets(ListThreatIntelSetsIterable.this.firstRequest);
            }
            return ListThreatIntelSetsIterable.this.client.listThreatIntelSets((ListThreatIntelSetsRequest)((Object)ListThreatIntelSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

