/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListMembersRequest;
import software.amazon.awssdk.services.guardduty.model.ListMembersResponse;
import software.amazon.awssdk.services.guardduty.model.Member;

public class ListMembersIterable
implements SdkIterable<ListMembersResponse> {
    private final GuardDutyClient client;
    private final ListMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMembersIterable(GuardDutyClient client, ListMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMembersResponseFetcher();
    }

    public Iterator<ListMembersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Member> members() {
        Function<ListMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListMembersIterable resume(ListMembersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListMembersIterable(this.client, (ListMembersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListMembersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListMembersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListMembersResponseFetcher
    implements SyncPageFetcher<ListMembersResponse> {
        private ListMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListMembersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListMembersResponse nextPage(ListMembersResponse previousPage) {
            if (previousPage == null) {
                return ListMembersIterable.this.client.listMembers(ListMembersIterable.this.firstRequest);
            }
            return ListMembersIterable.this.client.listMembers((ListMembersRequest)((Object)ListMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

