/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.Invitation;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;

public class ListInvitationsIterable
implements SdkIterable<ListInvitationsResponse> {
    private final GuardDutyClient client;
    private final ListInvitationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvitationsIterable(GuardDutyClient client, ListInvitationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInvitationsResponseFetcher();
    }

    public Iterator<ListInvitationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Invitation> invitations() {
        Function<ListInvitationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invitations() != null) {
                return response.invitations().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListInvitationsIterable resume(ListInvitationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInvitationsIterable(this.client, (ListInvitationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListInvitationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListInvitationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListInvitationsResponseFetcher
    implements SyncPageFetcher<ListInvitationsResponse> {
        private ListInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvitationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListInvitationsResponse nextPage(ListInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvitationsIterable.this.client.listInvitations(ListInvitationsIterable.this.firstRequest);
            }
            return ListInvitationsIterable.this.client.listInvitations((ListInvitationsRequest)((Object)ListInvitationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

