/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.ListIPSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIPSetsResponse;

public class ListIPSetsPublisher
implements SdkPublisher<ListIPSetsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListIPSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIPSetsPublisher(GuardDutyAsyncClient client, ListIPSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIPSetsPublisher(GuardDutyAsyncClient client, ListIPSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIPSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIPSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<String> ipSetIds() {
        Function<ListIPSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipSetIds() != null) {
                return response.ipSetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListIPSetsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListIPSetsPublisher resume(ListIPSetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListIPSetsPublisher(this.client, (ListIPSetsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListIPSetsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListIPSetsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListIPSetsResponseFetcher
    implements AsyncPageFetcher<ListIPSetsResponse> {
        private ListIPSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListIPSetsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListIPSetsResponse> nextPage(ListIPSetsResponse previousPage) {
            if (previousPage == null) {
                return ListIPSetsPublisher.this.client.listIPSets(ListIPSetsPublisher.this.firstRequest);
            }
            return ListIPSetsPublisher.this.client.listIPSets((ListIPSetsRequest)((Object)ListIPSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

