/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListIPSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIPSetsResponse;

public class ListIPSetsIterable
implements SdkIterable<ListIPSetsResponse> {
    private final GuardDutyClient client;
    private final ListIPSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIPSetsIterable(GuardDutyClient client, ListIPSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIPSetsResponseFetcher();
    }

    public Iterator<ListIPSetsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<String> ipSetIds() {
        Function<ListIPSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipSetIds() != null) {
                return response.ipSetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListIPSetsIterable resume(ListIPSetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListIPSetsIterable(this.client, (ListIPSetsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListIPSetsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListIPSetsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListIPSetsResponseFetcher
    implements SyncPageFetcher<ListIPSetsResponse> {
        private ListIPSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListIPSetsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListIPSetsResponse nextPage(ListIPSetsResponse previousPage) {
            if (previousPage == null) {
                return ListIPSetsIterable.this.client.listIPSets(ListIPSetsIterable.this.firstRequest);
            }
            return ListIPSetsIterable.this.client.listIPSets((ListIPSetsRequest)((Object)ListIPSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

