/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ListFindingsResponse;

public class ListFindingsIterable
implements SdkIterable<ListFindingsResponse> {
    private final GuardDutyClient client;
    private final ListFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFindingsIterable(GuardDutyClient client, ListFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFindingsResponseFetcher();
    }

    public Iterator<ListFindingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<String> findingIds() {
        Function<ListFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findingIds() != null) {
                return response.findingIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListFindingsIterable resume(ListFindingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFindingsIterable(this.client, (ListFindingsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListFindingsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListFindingsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListFindingsResponseFetcher
    implements SyncPageFetcher<ListFindingsResponse> {
        private ListFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListFindingsResponse nextPage(ListFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsIterable.this.client.listFindings(ListFindingsIterable.this.firstRequest);
            }
            return ListFindingsIterable.this.client.listFindings((ListFindingsRequest)((Object)ListFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

