/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;

public class ListDetectorsPublisher
implements SdkPublisher<ListDetectorsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListDetectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDetectorsPublisher(GuardDutyAsyncClient client, ListDetectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDetectorsPublisher(GuardDutyAsyncClient client, ListDetectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDetectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDetectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<String> detectorIds() {
        Function<ListDetectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.detectorIds() != null) {
                return response.detectorIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListDetectorsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListDetectorsPublisher resume(ListDetectorsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDetectorsPublisher(this.client, (ListDetectorsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDetectorsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDetectorsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDetectorsResponseFetcher
    implements AsyncPageFetcher<ListDetectorsResponse> {
        private ListDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListDetectorsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListDetectorsResponse> nextPage(ListDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListDetectorsPublisher.this.client.listDetectors(ListDetectorsPublisher.this.firstRequest);
            }
            return ListDetectorsPublisher.this.client.listDetectors((ListDetectorsRequest)((Object)ListDetectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

