/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDetectorRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateDetectorRequest> {
    private final String detectorId;
    private final Boolean enable;

    private UpdateDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.enable = builder.enable;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public Boolean enable() {
        return this.enable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorRequest)) {
            return false;
        }
        UpdateDetectorRequest other = (UpdateDetectorRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.enable(), other.enable());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDetectorRequest").add("DetectorId", (Object)this.detectorId()).add("Enable", (Object)this.enable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.of(clazz.cast(this.detectorId()));
            }
            case "Enable": {
                return Optional.of(clazz.cast(this.enable()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private Boolean enable;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.enable(model.enable);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDetectorRequest build() {
            return new UpdateDetectorRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, UpdateDetectorRequest> {
        public Builder detectorId(String var1);

        public Builder enable(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

