/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.guardduty.model.AccountIdsCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopMonitoringMembersRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, StopMonitoringMembersRequest> {
    private final List<String> accountIds;
    private final String detectorId;

    private StopMonitoringMembersRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.detectorId = builder.detectorId;
    }

    public List<String> accountIds() {
        return this.accountIds;
    }

    public String detectorId() {
        return this.detectorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopMonitoringMembersRequest)) {
            return false;
        }
        StopMonitoringMembersRequest other = (StopMonitoringMembersRequest)((Object)obj);
        return Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.detectorId(), other.detectorId());
    }

    public String toString() {
        return ToString.builder((String)"StopMonitoringMembersRequest").add("AccountIds", this.accountIds()).add("DetectorId", (Object)this.detectorId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.of(clazz.cast(this.accountIds()));
            }
            case "DetectorId": {
                return Optional.of(clazz.cast(this.detectorId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private List<String> accountIds;
        private String detectorId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopMonitoringMembersRequest model) {
            super(model);
            this.accountIds(model.accountIds);
            this.detectorId(model.detectorId);
        }

        public final Collection<String> getAccountIds() {
            return this.accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StopMonitoringMembersRequest build() {
            return new StopMonitoringMembersRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, StopMonitoringMembersRequest> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder detectorId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

