/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.transform.PrivateIpAddressDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PrivateIpAddressDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, PrivateIpAddressDetails> {
    private final String privateDnsName;
    private final String privateIpAddress;

    private PrivateIpAddressDetails(BuilderImpl builder) {
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateIpAddressDetails)) {
            return false;
        }
        PrivateIpAddressDetails other = (PrivateIpAddressDetails)obj;
        return Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress());
    }

    public String toString() {
        return ToString.builder((String)"PrivateIpAddressDetails").add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateIpAddress", (Object)this.privateIpAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrivateDnsName": {
                return Optional.of(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrivateIpAddressDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String privateDnsName;
        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateIpAddressDetails model) {
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public PrivateIpAddressDetails build() {
            return new PrivateIpAddressDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PrivateIpAddressDetails> {
        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);
    }
}

