/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.guardduty.model.FindingIdsCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFindingsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListFindingsResponse> {
    private final List<String> findingIds;
    private final String nextToken;

    private ListFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findingIds = builder.findingIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> findingIds() {
        return this.findingIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findingIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsResponse)) {
            return false;
        }
        ListFindingsResponse other = (ListFindingsResponse)((Object)obj);
        return Objects.equals(this.findingIds(), other.findingIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFindingsResponse").add("FindingIds", this.findingIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FindingIds": {
                return Optional.of(clazz.cast(this.findingIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<String> findingIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsResponse model) {
            super(model);
            this.findingIds(model.findingIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getFindingIds() {
            return this.findingIds;
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String ... findingIds) {
            this.findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFindingsResponse build() {
            return new ListFindingsResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, ListFindingsResponse> {
        public Builder findingIds(Collection<String> var1);

        public Builder findingIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

