/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetThreatIntelSetRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, GetThreatIntelSetRequest> {
    private final String detectorId;
    private final String threatIntelSetId;

    private GetThreatIntelSetRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.threatIntelSetId = builder.threatIntelSetId;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String threatIntelSetId() {
        return this.threatIntelSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.threatIntelSetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThreatIntelSetRequest)) {
            return false;
        }
        GetThreatIntelSetRequest other = (GetThreatIntelSetRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.threatIntelSetId(), other.threatIntelSetId());
    }

    public String toString() {
        return ToString.builder((String)"GetThreatIntelSetRequest").add("DetectorId", (Object)this.detectorId()).add("ThreatIntelSetId", (Object)this.threatIntelSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.of(clazz.cast(this.detectorId()));
            }
            case "ThreatIntelSetId": {
                return Optional.of(clazz.cast(this.threatIntelSetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String threatIntelSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetThreatIntelSetRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.threatIntelSetId(model.threatIntelSetId);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getThreatIntelSetId() {
            return this.threatIntelSetId;
        }

        @Override
        public final Builder threatIntelSetId(String threatIntelSetId) {
            this.threatIntelSetId = threatIntelSetId;
            return this;
        }

        public final void setThreatIntelSetId(String threatIntelSetId) {
            this.threatIntelSetId = threatIntelSetId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetThreatIntelSetRequest build() {
            return new GetThreatIntelSetRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, GetThreatIntelSetRequest> {
        public Builder detectorId(String var1);

        public Builder threatIntelSetId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

