/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.IpSetFormat;
import software.amazon.awssdk.services.guardduty.model.IpSetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIPSetResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetIPSetResponse> {
    private final String format;
    private final String location;
    private final String name;
    private final String status;

    private GetIPSetResponse(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.location = builder.location;
        this.name = builder.name;
        this.status = builder.status;
    }

    public IpSetFormat format() {
        return IpSetFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String location() {
        return this.location;
    }

    public String name() {
        return this.name;
    }

    public IpSetStatus status() {
        return IpSetStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIPSetResponse)) {
            return false;
        }
        GetIPSetResponse other = (GetIPSetResponse)((Object)obj);
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetIPSetResponse").add("Format", (Object)this.formatAsString()).add("Location", (Object)this.location()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.of(clazz.cast(this.formatAsString()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String format;
        private String location;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIPSetResponse model) {
            super(model);
            this.format(model.format);
            this.location(model.location);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(IpSetFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IpSetStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public GetIPSetResponse build() {
            return new GetIPSetResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, GetIPSetResponse> {
        public Builder format(String var1);

        public Builder format(IpSetFormat var1);

        public Builder location(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(IpSetStatus var1);
    }
}

