/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.guardduty.model.Finding;
import software.amazon.awssdk.services.guardduty.model.FindingsCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFindingsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetFindingsResponse> {
    private final List<Finding> findings;

    private GetFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
    }

    public List<Finding> findings() {
        return this.findings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsResponse)) {
            return false;
        }
        GetFindingsResponse other = (GetFindingsResponse)((Object)obj);
        return Objects.equals(this.findings(), other.findings());
    }

    public String toString() {
        return ToString.builder((String)"GetFindingsResponse").add("Findings", this.findings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Findings": {
                return Optional.of(clazz.cast(this.findings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<Finding> findings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsResponse model) {
            super(model);
            this.findings(model.findings);
        }

        public final Collection<Finding.Builder> getFindings() {
            return this.findings != null ? (Collection)this.findings.stream().map(Finding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findings(Collection<Finding> findings) {
            this.findings = FindingsCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Finding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<Finding.Builder> ... findings) {
            this.findings(Stream.of(findings).map(c -> (Finding)((Finding.Builder)Finding.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindings(Collection<Finding.BuilderImpl> findings) {
            this.findings = FindingsCopier.copyFromBuilder(findings);
        }

        @Override
        public GetFindingsResponse build() {
            return new GetFindingsResponse(this);
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    CopyableBuilder<Builder, GetFindingsResponse> {
        public Builder findings(Collection<Finding> var1);

        public Builder findings(Finding ... var1);

        public Builder findings(Consumer<Finding.Builder> ... var1);
    }
}

