/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.guardduty.model.Resource;
import software.amazon.awssdk.services.guardduty.model.Service;
import software.amazon.awssdk.services.guardduty.transform.FindingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Finding
implements StructuredPojo,
ToCopyableBuilder<Builder, Finding> {
    private final String accountId;
    private final String arn;
    private final Double confidence;
    private final String createdAt;
    private final String description;
    private final String id;
    private final String partition;
    private final String region;
    private final Resource resource;
    private final String schemaVersion;
    private final Service service;
    private final Double severity;
    private final String title;
    private final String type;
    private final String updatedAt;

    private Finding(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.confidence = builder.confidence;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.partition = builder.partition;
        this.region = builder.region;
        this.resource = builder.resource;
        this.schemaVersion = builder.schemaVersion;
        this.service = builder.service;
        this.severity = builder.severity;
        this.title = builder.title;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    public String accountId() {
        return this.accountId;
    }

    public String arn() {
        return this.arn;
    }

    public Double confidence() {
        return this.confidence;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public String description() {
        return this.description;
    }

    public String id() {
        return this.id;
    }

    public String partition() {
        return this.partition;
    }

    public String region() {
        return this.region;
    }

    public Resource resource() {
        return this.resource;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public Service service() {
        return this.service;
    }

    public Double severity() {
        return this.severity;
    }

    public String title() {
        return this.title;
    }

    public String type() {
        return this.type;
    }

    public String updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.partition());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.partition(), other.partition()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"Finding").add("AccountId", (Object)this.accountId()).add("Arn", (Object)this.arn()).add("Confidence", (Object)this.confidence()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Partition", (Object)this.partition()).add("Region", (Object)this.region()).add("Resource", (Object)this.resource()).add("SchemaVersion", (Object)this.schemaVersion()).add("Service", (Object)this.service()).add("Severity", (Object)this.severity()).add("Title", (Object)this.title()).add("Type", (Object)this.type()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Confidence": {
                return Optional.of(clazz.cast(this.confidence()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Partition": {
                return Optional.of(clazz.cast(this.partition()));
            }
            case "Region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "Resource": {
                return Optional.of(clazz.cast(this.resource()));
            }
            case "SchemaVersion": {
                return Optional.of(clazz.cast(this.schemaVersion()));
            }
            case "Service": {
                return Optional.of(clazz.cast(this.service()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severity()));
            }
            case "Title": {
                return Optional.of(clazz.cast(this.title()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "UpdatedAt": {
                return Optional.of(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FindingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String arn;
        private Double confidence;
        private String createdAt;
        private String description;
        private String id;
        private String partition;
        private String region;
        private Resource resource;
        private String schemaVersion;
        private Service service;
        private Double severity;
        private String title;
        private String type;
        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            this.accountId(model.accountId);
            this.arn(model.arn);
            this.confidence(model.confidence);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.id(model.id);
            this.partition(model.partition);
            this.region(model.region);
            this.resource(model.resource);
            this.schemaVersion(model.schemaVersion);
            this.service(model.service);
            this.severity(model.severity);
            this.title(model.title);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Double getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPartition() {
            return this.partition;
        }

        @Override
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final Service.Builder getService() {
            return this.service != null ? this.service.toBuilder() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        public final Double getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(Double severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(Double severity) {
            this.severity = severity;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public Finding build() {
            return new Finding(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Finding> {
        public Builder accountId(String var1);

        public Builder arn(String var1);

        public Builder confidence(Double var1);

        public Builder createdAt(String var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder partition(String var1);

        public Builder region(String var1);

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().apply(resource)).build());
        }

        public Builder schemaVersion(String var1);

        public Builder service(Service var1);

        default public Builder service(Consumer<Service.Builder> service) {
            return this.service((Service)((Service.Builder)Service.builder().apply(service)).build());
        }

        public Builder severity(Double var1);

        public Builder title(String var1);

        public Builder type(String var1);

        public Builder updatedAt(String var1);
    }
}

