/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteIPSetRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, DeleteIPSetRequest> {
    private final String detectorId;
    private final String ipSetId;

    private DeleteIPSetRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.ipSetId = builder.ipSetId;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String ipSetId() {
        return this.ipSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIPSetRequest)) {
            return false;
        }
        DeleteIPSetRequest other = (DeleteIPSetRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.ipSetId(), other.ipSetId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteIPSetRequest").add("DetectorId", (Object)this.detectorId()).add("IpSetId", (Object)this.ipSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.of(clazz.cast(this.detectorId()));
            }
            case "IpSetId": {
                return Optional.of(clazz.cast(this.ipSetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String ipSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIPSetRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.ipSetId(model.ipSetId);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getIpSetId() {
            return this.ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIpSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteIPSetRequest build() {
            return new DeleteIPSetRequest(this);
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    CopyableBuilder<Builder, DeleteIPSetRequest> {
        public Builder detectorId(String var1);

        public Builder ipSetId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

