/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationAsyncClient;
import software.amazon.awssdk.services.groundstation.internal.UserAgentUtils;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse;
import software.amazon.awssdk.services.groundstation.model.SatelliteListItem;

public class ListSatellitesPublisher
implements SdkPublisher<ListSatellitesResponse> {
    private final GroundStationAsyncClient client;
    private final ListSatellitesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSatellitesPublisher(GroundStationAsyncClient client, ListSatellitesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSatellitesPublisher(GroundStationAsyncClient client, ListSatellitesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSatellitesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSatellitesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SatelliteListItem> satellites() {
        Function<ListSatellitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.satellites() != null) {
                return response.satellites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSatellitesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSatellitesResponseFetcher
    implements AsyncPageFetcher<ListSatellitesResponse> {
        private ListSatellitesResponseFetcher() {
        }

        public boolean hasNextPage(ListSatellitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSatellitesResponse> nextPage(ListSatellitesResponse previousPage) {
            if (previousPage == null) {
                return ListSatellitesPublisher.this.client.listSatellites(ListSatellitesPublisher.this.firstRequest);
            }
            return ListSatellitesPublisher.this.client.listSatellites((ListSatellitesRequest)((Object)ListSatellitesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

