/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationClient;
import software.amazon.awssdk.services.groundstation.internal.UserAgentUtils;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsRequest;
import software.amazon.awssdk.services.groundstation.model.ListDataflowEndpointGroupsResponse;

public class ListDataflowEndpointGroupsIterable
implements SdkIterable<ListDataflowEndpointGroupsResponse> {
    private final GroundStationClient client;
    private final ListDataflowEndpointGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataflowEndpointGroupsIterable(GroundStationClient client, ListDataflowEndpointGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataflowEndpointGroupsResponseFetcher();
    }

    public Iterator<ListDataflowEndpointGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataflowEndpointListItem> dataflowEndpointGroupList() {
        Function<ListDataflowEndpointGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataflowEndpointGroupList() != null) {
                return response.dataflowEndpointGroupList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataflowEndpointGroupsResponseFetcher
    implements SyncPageFetcher<ListDataflowEndpointGroupsResponse> {
        private ListDataflowEndpointGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataflowEndpointGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataflowEndpointGroupsResponse nextPage(ListDataflowEndpointGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDataflowEndpointGroupsIterable.this.client.listDataflowEndpointGroups(ListDataflowEndpointGroupsIterable.this.firstRequest);
            }
            return ListDataflowEndpointGroupsIterable.this.client.listDataflowEndpointGroups((ListDataflowEndpointGroupsRequest)((Object)ListDataflowEndpointGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

