/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationAsyncClient;
import software.amazon.awssdk.services.groundstation.internal.UserAgentUtils;
import software.amazon.awssdk.services.groundstation.model.ConfigListItem;
import software.amazon.awssdk.services.groundstation.model.ListConfigsRequest;
import software.amazon.awssdk.services.groundstation.model.ListConfigsResponse;

public class ListConfigsPublisher
implements SdkPublisher<ListConfigsResponse> {
    private final GroundStationAsyncClient client;
    private final ListConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigsPublisher(GroundStationAsyncClient client, ListConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigsPublisher(GroundStationAsyncClient client, ListConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigListItem> configList() {
        Function<ListConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configList() != null) {
                return response.configList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfigsResponseFetcher
    implements AsyncPageFetcher<ListConfigsResponse> {
        private ListConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigsResponse> nextPage(ListConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigsPublisher.this.client.listConfigs(ListConfigsPublisher.this.firstRequest);
            }
            return ListConfigsPublisher.this.client.listConfigs((ListConfigsRequest)((Object)ListConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

