/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEphemeridesResponse extends GroundStationResponse implements
        ToCopyableBuilder<ListEphemeridesResponse.Builder, ListEphemeridesResponse> {
    private static final SdkField<List<EphemerisItem>> EPHEMERIDES_FIELD = SdkField
            .<List<EphemerisItem>> builder(MarshallingType.LIST)
            .memberName("ephemerides")
            .getter(getter(ListEphemeridesResponse::ephemerides))
            .setter(setter(Builder::ephemerides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EphemerisItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EphemerisItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEphemeridesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPHEMERIDES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EphemerisItem> ephemerides;

    private final String nextToken;

    private ListEphemeridesResponse(BuilderImpl builder) {
        super(builder);
        this.ephemerides = builder.ephemerides;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ephemerides property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEphemerides() {
        return ephemerides != null && !(ephemerides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of ephemerides.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEphemerides} method.
     * </p>
     * 
     * @return List of ephemerides.
     */
    public final List<EphemerisItem> ephemerides() {
        return ephemerides;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEphemerides() ? ephemerides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEphemeridesResponse)) {
            return false;
        }
        ListEphemeridesResponse other = (ListEphemeridesResponse) obj;
        return hasEphemerides() == other.hasEphemerides() && Objects.equals(ephemerides(), other.ephemerides())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEphemeridesResponse").add("Ephemerides", hasEphemerides() ? ephemerides() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ephemerides":
            return Optional.ofNullable(clazz.cast(ephemerides()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEphemeridesResponse, T> g) {
        return obj -> g.apply((ListEphemeridesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEphemeridesResponse> {
        /**
         * <p>
         * List of ephemerides.
         * </p>
         * 
         * @param ephemerides
         *        List of ephemerides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemerides(Collection<EphemerisItem> ephemerides);

        /**
         * <p>
         * List of ephemerides.
         * </p>
         * 
         * @param ephemerides
         *        List of ephemerides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemerides(EphemerisItem... ephemerides);

        /**
         * <p>
         * List of ephemerides.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.groundstation.model.EphemerisItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.groundstation.model.EphemerisItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.groundstation.model.EphemerisItem.Builder#build()} is called
         * immediately and its result is passed to {@link #ephemerides(List<EphemerisItem>)}.
         * 
         * @param ephemerides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.groundstation.model.EphemerisItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ephemerides(java.util.Collection<EphemerisItem>)
         */
        Builder ephemerides(Consumer<EphemerisItem.Builder>... ephemerides);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private List<EphemerisItem> ephemerides = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEphemeridesResponse model) {
            super(model);
            ephemerides(model.ephemerides);
            nextToken(model.nextToken);
        }

        public final List<EphemerisItem.Builder> getEphemerides() {
            List<EphemerisItem.Builder> result = EphemeridesListCopier.copyToBuilder(this.ephemerides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEphemerides(Collection<EphemerisItem.BuilderImpl> ephemerides) {
            this.ephemerides = EphemeridesListCopier.copyFromBuilder(ephemerides);
        }

        @Override
        public final Builder ephemerides(Collection<EphemerisItem> ephemerides) {
            this.ephemerides = EphemeridesListCopier.copy(ephemerides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ephemerides(EphemerisItem... ephemerides) {
            ephemerides(Arrays.asList(ephemerides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ephemerides(Consumer<EphemerisItem.Builder>... ephemerides) {
            ephemerides(Stream.of(ephemerides).map(c -> EphemerisItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEphemeridesResponse build() {
            return new ListEphemeridesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
