/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationAsyncClient;
import software.amazon.awssdk.services.groundstation.internal.UserAgentUtils;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesRequest;
import software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse;
import software.amazon.awssdk.services.groundstation.model.MissionProfileListItem;

public class ListMissionProfilesPublisher
implements SdkPublisher<ListMissionProfilesResponse> {
    private final GroundStationAsyncClient client;
    private final ListMissionProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMissionProfilesPublisher(GroundStationAsyncClient client, ListMissionProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMissionProfilesPublisher(GroundStationAsyncClient client, ListMissionProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMissionProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMissionProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MissionProfileListItem> missionProfileList() {
        Function<ListMissionProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.missionProfileList() != null) {
                return response.missionProfileList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMissionProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMissionProfilesResponseFetcher
    implements AsyncPageFetcher<ListMissionProfilesResponse> {
        private ListMissionProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListMissionProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMissionProfilesResponse> nextPage(ListMissionProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListMissionProfilesPublisher.this.client.listMissionProfiles(ListMissionProfilesPublisher.this.firstRequest);
            }
            return ListMissionProfilesPublisher.this.client.listMissionProfiles((ListMissionProfilesRequest)((Object)ListMissionProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

